//=============================================================================
// Job Button.
//=============================================================================
class JobButtonC extends DeusExDecoration;

var() float buttonLitTime;
var() sound buttonSound1;
var() sound buttonSound2;
var() bool bLit;
var() bool bWaitForEvent;
var bool isPressed;

var Vector	lastLoc, rpcLocation;
var bool		bIsMoving;

//var() ShopButtonC ShopButtons[25];
//var() EmployeeButtonC EmployeeButtons[3];
//obsolete------------------------

//new stuff
var() localized string EmployeeButtonString, ShopButtonString;

//old stuff
var() bool bModLooks;
var() texture JobClothes[8];
var() mesh JobMesh;
var() localized string JobMessage;
var() localized string JobName;
var() localized string VendorString;
var DeusexPlayer ShopOwner;
var() EmployeeButtonC SpecialEmployee;

replication 
{
	reliable if ( Role == ROLE_Authority )
		rpcLocation;
}

function Trigger(Actor Other, Pawn Instigator)
{
	if (bWaitForEvent)
		Timer();
}

function Timer()
{
	PlaySound(buttonSound2, SLOT_None);
	isPressed = False;
}

function AbandonShop()
{
local EmployeeButtonC E;
local ShopButtonC S;
local MSVendor V;

forEach AllActors(class'EmployeeButtonC', E)
{
 if ((E != None) && (E.ShopString ~= EmployeeButtonString))
 {
  E.SetOwner(None);
  E.SetTimer(1, False);
 }
}


forEach AllActors(class'ShopButtonC', S)
{
 if ((S != None) && (S.ShopString ~= ShopButtonString))
 {
  S.SetOwner(None);
 }
}

forEach AllActors(class'MSVendor', V)
{
 if ((V != None) && (V.ShopString ~= VendorString))
 {
  V.BenifactorName = "";
 }
}
}

function SetStuffsOwner()
{
local EmployeeButtonC E;
local ShopButtonC S;
local MSVendor V;

  if ((SpecialEmployee != None) && (SpecialEmployee.ShopOwner != None))
  {
       ShopOwner = SpecialEmployee.ShopOwner;
       BroadcastMessage("|p4"$SpecialEmployee.ShopOwner.PlayerReplicationInfo.PlayerName$"|p3 has been promoted to the position of |p7"$JobName$"", true, 'CriticalEvent'); // Broadcast message to all players.
       E.SetOwner(SpecialEmployee.ShopOwner);
       SpecialEmployee.ShopOwner = None;
     if (bModLooks)
     {
     SpecialEmployee.MultiSkins[0] = JobClothes[0];
     SpecialEmployee.MultiSkins[1] = JobClothes[1];
     SpecialEmployee.MultiSkins[2] = JobClothes[2];
     SpecialEmployee.MultiSkins[3] = JobClothes[3];
     SpecialEmployee.MultiSkins[4] = JobClothes[4];
     SpecialEmployee.MultiSkins[5] = JobClothes[5];
     SpecialEmployee.MultiSkins[6] = JobClothes[6];
     SpecialEmployee.MultiSkins[7] = JobClothes[7];
     SpecialEmployee.Mesh = JobMesh;
     }
forEach AllActors(class'ShopButtonC', S)
{
 if ((S != None) && (S.ShopString ~= ShopButtonString))
 {
       S.SetOwner(SpecialEmployee.ShopOwner);    
 }
}
forEach AllActors(class'EmployeeButtonC', E)
{
 if ((E != None) && (E.ShopString ~= EmployeeButtonString))
 {
       E.SetOwner(SpecialEmployee.ShopOwner);    
 }
}

forEach AllActors(class'MSVendor', V)
{
 if ((V != None) && (V.ShopString ~= VendorString))
 {
  V.BenifactorName = SpecialEmployee.ShopOwner.PlayerReplicationInfo.PlayerName;
 }
}
   }
}

function ManTheShop(DeusExPlayer DaPimp)
{
 local ShopButtonC S;
 local EmployeeButtonC E;
 local MSVendor V;

forEach AllActors(class'ShopButtonC', S)
{
 if ((S != None) && (S.ShopString ~= ShopButtonString))
 {
  S.SetOwner(DaPimp);
 }
}

forEach AllActors(class'EmployeeButtonC', E)
{
 if ((E != None) && (E.ShopString ~= EmployeeButtonString))
 {
   E.SetOwner(DaPimp);
 }
}

forEach AllActors(class'MSVendor', V)
{
 if ((V != None) && (V.ShopString ~= VendorString))
 {
  V.BenifactorName = DaPimp.PlayerReplicationInfo.PlayerName;
 }
}

}

function Frob(Actor Frobber, Inventory frobWith)
{
local Actor A;
local DeusExPlayer P;
local ShopButtonC S;
local EmployeeButtonC E;

  P = DeusExPlayer(Frobber);

     Super.Frob(Frobber, frobwith);

     if ((ShopOwner != None) && (Frobber != ShopOwner))
     ShopOwner.ClientMessage("|p2"$P.PlayerReplicationInfo.PlayerName$" has taken over the position of "$JobName$"!");
     if ((ShopOwner != None) && (Frobber == ShopOwner))
     {
     BroadcastMessage("|p4"$P.PlayerReplicationInfo.PlayerName$"|p4 has resigned from the position of |p3"$JobName$"", true, 'CriticalEvent'); // Broadcast message to all players.
     ShopOwner = None;
     AbandonShop();
     if (SpecialEmployee != None)
     {
      SetStuffsOwner();
      return;
     }
     else return;
     }
     if (P != ShopOwner)
     {
     ManTheShop(DeusExPlayer(Frobber));
     BroadcastMessage("|p3"$P.PlayerReplicationInfo.PlayerName$"|p4 is now |p2"$JobName$"", true, 'CriticalEvent'); // Broadcast message to all players.
     P.ClientMessage(JobMessage);
     ShopOwner = P;

     if (bModLooks)
     {
     P.MultiSkins[0] = JobClothes[0];
     P.MultiSkins[1] = JobClothes[1];
     P.MultiSkins[2] = JobClothes[2];
     P.MultiSkins[3] = JobClothes[3];
     P.MultiSkins[4] = JobClothes[4];
     P.MultiSkins[5] = JobClothes[5];
     P.MultiSkins[6] = JobClothes[6];
     P.MultiSkins[7] = JobClothes[7];
     P.Mesh = JobMesh;
     }
}

}



singular function SupportActor(Actor standingActor)
{
	// do nothing
}

function Bump(actor Other)
{
	// do nothing
}

simulated function Tick( float deltaTime )
{						  	
	if ( Level.NetMode != NM_Standalone )
	{
		if ( Role == ROLE_Authority )
		{
			// Was moving, now at rest
			if ( bIsMoving && ( Location == lastLoc ))
				rpcLocation = Location;

			bIsMoving = ( Location != lastLoc );
			lastLoc = Location;
		}
		else
		{
			// Our replicated location changed which means the button has come to rest
			if ( lastLoc != rpcLocation )
			{
				SetLocation( rpcLocation );
				lastLoc = rpcLocation;
			}
		}
	}
	Super.Tick( deltaTime );
}

defaultproperties
{
     buttonLitTime=0.500000
     buttonSound1=Sound'DeusExSounds.Generic.Beep1'
     bInvincible=True
     ItemName="|p4Job Button"
     bPushable=False
     Physics=PHYS_None
     RemoteRole=ROLE_SimulatedProxy
     Mesh=LodMesh'DeusExDeco.Button1'
     CollisionRadius=2.000000
     CollisionHeight=2.000000
     bCollideWorld=False
     bBlockActors=False
     Mass=5.000000
     Buoyancy=2.000000
}
